import codecs
import re

# --- 1. DIZIONARI DI DECODIFICA (INVERSI) ---
REVERSE_MAPPA_RENDITA = { "ddd": 100, "dde": 101, "add": 200 }
REVERSE_MAPPA_POSSESSO = { "rrbegt": 100, "abead": 50 }
REVERSE_MAPPA_MESE_INIZIO = { "cn": "Gennaio", "dd": "Febbraio", "de": "Marzo", "bq": "Aprile" }
REVERSE_MAPPA_MESE_FINE = { "ddpdd": "Dicembre", "dfodd": "Novembre" }
REVERSE_MAPPA_ALIQUOTA = { "caddf": 11.4, "cuadd": 10.6 }
REVERSE_MAPPA_STORICO_INAGIBILE = { "hop": "NO", "dd": "SI_STORICO", "cn": "SI_INAGIBILE" }
REVERSE_MAPPA_OUTPUT_TOTALE = { "eefodd": 191.52, "eefxqd": 193.44, "vxdfdd": 383.04, "cyfodd": "95.76 o 178.08" }
REVERSE_MAPPA_OUTPUT_SEMESTRE = { "vxcudd": 95.76, "vxcxqd": 96.72, "vxbegt": 191.52, "chfodd": "47.88 o 89.04" }

# --- 2. FUNZIONE DI DECODIFICA ---
def decode_payload(payload_string):
    decoded_data = {}
    errors = []

    # Espressioni Regolari per estrarre i token nel contesto corretto
    match_rendita = re.search(r'reke([a-z]{3})fmu', payload_string)
    if match_rendita: token = match_rendita.group(1); decoded_data['Rendita Catastale'] = REVERSE_MAPPA_RENDITA.get(token, f"Sconosciuto ({token})")
    else: errors.append("Rendita non trovata.")

    match_mese_inizio = re.search(r'advhmahoadde([a-z]{2})hoaddecndfuufogg', payload_string)
    if match_mese_inizio: token = match_mese_inizio.group(1); decoded_data['Mese Inizio'] = REVERSE_MAPPA_MESE_INIZIO.get(token, f"Sconosciuto ({token})")
    else: errors.append("Mese Inizio non trovato.")

    match_mese_fine = re.search(r'pqqgcaddfqqsia([a-z]{5})xvddraqath', payload_string)
    if match_mese_fine: token = match_mese_fine.group(1); decoded_data['Mese Fine'] = REVERSE_MAPPA_MESE_FINE.get(token, f"Sconosciuto ({token})")
    else: errors.append("Mese Fine non trovato.")

    match_aliquota = re.search(r'pqqgc([a-z]{5})qqsi', payload_string)
    if match_aliquota:
        token = match_aliquota.group(1)
        value = REVERSE_MAPPA_ALIQUOTA.get(token)
        decoded_data['Aliquota'] = f"{value} ‰" if value else f"Sconosciuto ({token})"
    else: errors.append("Aliquota non trovata.")

    match_possesso = re.search(r'cycsqadqcyrappvh([a-z]{6})gcresiesarvxdfddsraddpgodf', payload_string)
    if match_possesso:
        token = match_possesso.group(1)
        value = REVERSE_MAPPA_POSSESSO.get(token)
        decoded_data['Percentuale Possesso'] = f"{value}%" if value else f"Sconosciuto ({token})"
    else: errors.append("Percentuale Possesso non trovata.")

    match_storico = re.search(r'fmu([a-z]{2,3})xvddrabepp', payload_string)
    if match_storico:
        token = match_storico.group(1)
        decoded_data['Storico/Inagibile'] = REVERSE_MAPPA_STORICO_INAGIBILE.get(token, f"Sconosciuto ({token})")
        if token in ["cn", "dd"]: decoded_data['Storico/Inagibile'] += " (Potenzialmente ambiguo!)"
    else: errors.append("Storico/Inagibile non trovato.")

    # Estrazione Output (Opzionale)
    match_output_tot = re.search(r'sereqaar([a-z]{6})srddvhddgoadvhmahoadde', payload_string)
    if match_output_tot: token = match_output_tot.group(1); decoded_data['[Output] IMU Totale Salvata'] = REVERSE_MAPPA_OUTPUT_TOTALE.get(token, f"Sconosciuto ({token})")
    match_output_sem = re.search(r'fuufoggtheedrpppesereqaar([a-z]{6})srddvhddgoadvhmahoadde', payload_string)
    if match_output_sem: token = match_output_sem.group(1); decoded_data['[Output] Semestre Salvato'] = REVERSE_MAPPA_OUTPUT_SEMESTRE.get(token, f"Sconosciuto ({token})")

    if errors:
        print("\n--- AVVISI DURANTE LA DECODIFICA ---")
        for error in errors: print(f"- {error}")
        print("Il payload potrebbe essere per una categoria diversa o incompleto.")

    return decoded_data

# --- 3. ESECUZIONE ---
print("--- DECODIFICATORE DI FILE .AMN (SOLO PAYLOAD 'Altre abitazioni') ---")
file_da_decodificare = input("Nome del file .amn da decodificare: ")

try:
    with codecs.open(file_da_decodificare, 'r', encoding='latin-1') as f:
        contenuto_completo = f.read()

    parti = contenuto_completo.split('iiii')
    if len(parti) >= 2: # Almeno Header e Payload
        payload = parti[1]
        print(f"\n--- DATI DECODIFICATI DAL PAYLOAD ({file_da_decodificare}) ---")
        dati_decodificati = decode_payload(payload)
        if dati_decodificati:
            for chiave, valore in dati_decodificati.items():
                print(f"- {chiave}: {valore}")
        else:
            print("Nessun dato riconosciuto nel payload.")
    else:
        print(f"Errore: Struttura del file '{file_da_decodificare}' non valida (mancano 'iiii').")

except FileNotFoundError:
    print(f"Errore: File '{file_da_decodificare}' non trovato.")
except Exception as e:
    print(f"Errore durante l'elaborazione: {e}")